/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common;

import java.util.ArrayList;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class NoteEvent {
    public byte note;
    public short time;
    public byte volume;
    public byte length;

    public NoteEvent(byte note, short time, byte volume, byte length) {
        this.note = note;
        this.time = time;
        this.volume = volume;
        this.length = length;
    }

    public NoteEvent() {
    }

    public short endTime() {
        return (short)(this.time + this.length - 1);
    }

    public short startTime() {
        return this.time;
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10567("n", this.note);
        tag.method_10575("d", this.time);
        tag.method_10567("v", this.volume);
        tag.method_10567("l", this.length);
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        this.note = tag.method_10571("n");
        this.time = tag.method_10568("d");
        this.volume = tag.method_10571("v");
        this.length = tag.method_10571("l");
    }

    public static NoteEvent fromNBT(class_2487 tag) {
        NoteEvent noteEvent = new NoteEvent();
        noteEvent.deserializeNBT(tag);
        return noteEvent;
    }

    public void encodeToBuffer(class_2540 buf) {
        buf.method_52997((int)this.note);
        buf.method_52998((int)this.time);
        buf.method_52997((int)this.volume);
        buf.method_52997((int)this.length);
    }

    public void decodeFromBuffer(class_2540 buf) {
        this.note = buf.readByte();
        this.time = buf.readShort();
        this.volume = buf.readByte();
        this.length = buf.readByte();
    }

    public static NoteEvent fromBuffer(class_2540 buf) {
        NoteEvent noteEvent = new NoteEvent();
        noteEvent.decodeFromBuffer(buf);
        return noteEvent;
    }

    public static void fillArrayFromNBT(ArrayList<NoteEvent> noteEvents, class_2487 tag) {
        class_2499 notesTag = tag.method_10554("notes", 10);
        for (int i = 0; i < notesTag.size(); ++i) {
            noteEvents.add(NoteEvent.fromNBT(notesTag.method_10602(i)));
        }
    }

    public static void fillNBTFromArray(ArrayList<NoteEvent> noteEvents, class_2487 tag) {
        class_2499 noteList = new class_2499();
        for (NoteEvent event : noteEvents) {
            noteList.add((Object)event.serializeNBT());
        }
        tag.method_10566("notes", (class_2520)noteList);
    }

    public float floatVolume() {
        return (float)this.volume / 127.0f;
    }

    public NoteEvent clone() {
        return new NoteEvent(this.note, this.time, this.volume, this.length);
    }
}

